<?php
include 'db.php';
$msg = '';
$token = $_GET['token'] ?? '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $token = $_POST['token'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $stmt = $conn->prepare("UPDATE users SET password=?, reset_token=NULL WHERE reset_token=?");
    $stmt->bind_param("ss", $password, $token);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        $msg = "Password reset successful. <a href='login.php'>Login</a>";
    } else {
        $msg = "Invalid or expired token.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <title>Reset Password</title>
</head>
<body class="container">
    <h2>Reset Password</h2>
    <form method="post">
        <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
        <input class="form-control mb-2" name="password" type="password" placeholder="New Password" required>
        <button class="btn btn-primary" type="submit">Reset</button>
    </form>
    <div><?= $msg ?></div>
</body>
</html>
