<!DOCTYPE html>
<html>
<head>
    <title>Printers - HUKO PRINT</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<nav class="navbar navbar-light bg-light mb-4">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="#">
            <img src="logo.png" alt="Logo" width="40" height="40" class="me-2">
            <span class="fs-4 fw-bold">HUKO PRINT</span>
        </a>
    </div>
</nav>
<div class="container">
<?php
header('Content-Type: application/json');
include 'db.php';

// Read POST data and verify api_key
$api_key = $_POST['api_key'] ?? '';
$action = $_POST['action'] ?? '';

if (!$api_key) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing api_key']);
    exit;
}

// Get user_id from api_key
$user_stmt = $conn->prepare("SELECT id FROM users WHERE api_key=?");
$user_stmt->bind_param("s", $api_key);
$user_stmt->execute();
$user_stmt->bind_result($user_id);
if (!$user_stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid api_key']);
    exit;
}
$user_stmt->close();

if ($action === 'get_printers') {
    // List printers belonging to user (tbl_printers must have user_id column)
    $printers = [];
    $stmt = $conn->prepare("SELECT id, unique_id, name, type, characters_per_line, print_format, status, time_added, last_updated FROM tbl_printers WHERE user_id=?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) $printers[] = $row;
    $stmt->close();
    echo json_encode(['success' => true, 'printers' => $printers]);
    exit;
}

if ($action === 'send_printjob') {
    $printer_id = $_POST['printer_id'] ?? '';
    $type = $_POST['type'] ?? '';
    $content = $_POST['content'] ?? '';

    if (!$printer_id || !$type || !$content) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Missing parameters']);
        exit;
    }

    // Verify printer belongs to user
    $printer_stmt = $conn->prepare("SELECT id FROM tbl_printers WHERE unique_id=? AND user_id=?");
    $printer_stmt->bind_param("si", $printer_id, $user_id);
    $printer_stmt->execute();
    $printer_stmt->store_result();
    if ($printer_stmt->num_rows == 0) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Printer does not belong to user']);
        exit;
    }
    $printer_stmt->close();

    // Just validate and return success
    echo json_encode(['success' => true, 'message' => 'Print job validated']);
    exit;
}

http_response_code(400);
echo json_encode(['success' => false, 'message' => 'Invalid action']);
?>
</div>
</body>
</html>