<?php
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $admin_user = $_POST['admin_user'];
    $admin_email = $_POST['admin_email'];
    $admin_pass = password_hash($_POST['admin_pass'], PASSWORD_DEFAULT);

    $conn = new mysqli($host, $user, $pass);
    if ($conn->connect_error) {
        $msg = "Connection failed: " . $conn->connect_error;
    } else {
        // Create database
        if ($conn->query("CREATE DATABASE IF NOT EXISTS `$db`")) {
            $conn->select_db($db);
            // Create users table
            $table_sql = "CREATE TABLE IF NOT EXISTS users (
                id INT AUTO_INCREMENT PRIMARY KEY,
                username VARCHAR(50) NOT NULL,
                email VARCHAR(100) NOT NULL UNIQUE,
                password VARCHAR(255) NOT NULL,
                role ENUM('admin','user') DEFAULT 'user',
                reset_token VARCHAR(32) DEFAULT NULL
            )";
            if ($conn->query($table_sql)) {
                // Insert admin user if not exists
                $stmt = $conn->prepare("SELECT id FROM users WHERE email=?");
                $stmt->bind_param("s", $admin_email);
                $stmt->execute();
                $stmt->store_result();
                if ($stmt->num_rows == 0) {
                    $insert = $conn->prepare("INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, 'admin')");
                    $insert->bind_param("sss", $admin_user, $admin_email, $admin_pass);
                    if ($insert->execute()) {
                        $msg = "<div class='alert alert-success'>Install complete! Admin user created.</div>";
                    } else {
                        $msg = "<div class='alert alert-danger'>Error creating admin user: " . $insert->error . "</div>";
                    }
                } else {
                    $msg = "<div class='alert alert-warning'>Admin user already exists.</div>";
                }
            } else {
                $msg = "<div class='alert alert-danger'>Error creating table: " . $conn->error . "</div>";
            }
            // Create tbl_printers table
            $printers_sql = "CREATE TABLE IF NOT EXISTS tbl_printers (
                id INT AUTO_INCREMENT PRIMARY KEY,
                unique_id VARCHAR(64) NOT NULL UNIQUE,
                name VARCHAR(100) NOT NULL,
                type VARCHAR(50) NOT NULL,
                characters_per_line INT NOT NULL,
                print_format TEXT,
                status ENUM('active','inactive') DEFAULT 'active',
                time_added DATETIME DEFAULT CURRENT_TIMESTAMP,
                last_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            )";
            if ($conn->query($printers_sql)) {
                // Insert sample printer if not exists
                $check = $conn->query("SELECT id FROM tbl_printers WHERE unique_id='PRN001'");
                if ($check->num_rows == 0) {
                    $insert_printer = $conn->prepare("INSERT INTO tbl_printers (unique_id, name, type, characters_per_line, print_format, status) VALUES (?, ?, ?, ?, ?, ?)");
                    $uid = 'PRN001';
                    $name = 'Sample Printer';
                    $type = 'Thermal';
                    $cpl = 32;
                    $format = 'Default Format';
                    $status = 'active';
                    $insert_printer->bind_param("sssiss", $uid, $name, $type, $cpl, $format, $status);
                    $insert_printer->execute();
                }
            } else {
                $msg = "<div class='alert alert-danger'>Error creating printers table: " . $conn->error . "</div>";
            }
        } else {
            $msg = "<div class='alert alert-danger'>Error creating database: " . $conn->error . "</div>";
        }
        $conn->close();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Install Hukoprint</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="container py-5">
    <h2>Install Hukoprint</h2>
    <form method="post" class="mb-3">
        <input class="form-control mb-2" name="admin_user" placeholder="Admin Username" required>
        <input class="form-control mb-2" name="admin_email" type="email" placeholder="Admin Email" required>
        <input class="form-control mb-2" name="admin_pass" type="password" placeholder="Admin Password" required>
        <button class="btn btn-primary" type="submit">Install</button>
    </form>
    <?= $msg ?>
</body>
</html>
