<?php
include 'db.php';
$msg = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $token = bin2hex(random_bytes(16));
    $stmt = $conn->prepare("UPDATE users SET reset_token=? WHERE email=?");
    $stmt->bind_param("ss", $token, $email);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        // In production, send email. Here, just show link.
        $msg = "Reset link: <a href='reset.php?token=$token'>Reset Password</a>";
    } else {
        $msg = "Email not found.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <title>Forgot Password</title>
</head>
<body class="container">
    <h2>Forgot Password</h2>
    <form method="post">
        <input class="form-control mb-2" name="email" type="email" placeholder="Email" required>
        <button class="btn btn-primary" type="submit">Send Reset Link</button>
    </form>
    <div><?= $msg ?></div>
    <a href="login.php">Login</a>
</body>
</html>
