<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$role = $_SESSION['role'];
include 'db.php';
$printers = $conn->query("SELECT * FROM tbl_printers ORDER BY time_added DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard - HUKO PRINT</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        .sidebar { min-width: 200px; }
        .sidebar .nav-link.active { background: #0d6efd; color: #fff; }
    </style>
</head>
<body>
<nav class="navbar navbar-light bg-light mb-4">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="#">
            <img src="logo.png" alt="Logo" width="40" height="40" class="me-2">
            <span class="fs-4 fw-bold">HUKO PRINT</span>
        </a>
    </div>
</nav>
<div class="d-flex container">
    <nav class="sidebar bg-light p-3">
        <h4>Menu</h4>
        <ul class="nav flex-column">
            <li class="nav-item"><a class="nav-link active" href="dashboard.php">View Printers</a></li>
            <li class="nav-item"><a class="nav-link" href="add_printer.php">Add Printer</a></li>
            <li class="nav-item"><a class="nav-link" href="#">WebHooks</a></li>
            <li class="nav-item"><a class="nav-link" href="#">APIs</a></li>
        </ul>
    </nav>
    <main class="flex-fill p-4">
        <h2>Printers</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Unique ID</th>
                    <th>Name</th>
                    <th>Type</th>
                    <th>Characters/Line</th>
                    <th>Format</th>
                    <th>Status</th>
                    <th>Added</th>
                    <th>Updated</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $printers->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['unique_id']) ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['type']) ?></td>
                    <td><?= $row['characters_per_line'] ?></td>
                    <td><?= htmlspecialchars($row['print_format']) ?></td>
                    <td><?= htmlspecialchars($row['status']) ?></td>
                    <td><?= $row['time_added'] ?></td>
                    <td><?= $row['last_updated'] ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </main>
</div>
</body>
</html>
