<?php
include 'db.php';
$msg = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $unique_id = $_POST['unique_id'];
    $name = $_POST['name'];
    $type = $_POST['type'];
    $cpl = intval($_POST['characters_per_line']);
    $format = $_POST['print_format'];
    $status = $_POST['status'];
    $stmt = $conn->prepare("INSERT INTO tbl_printers (unique_id, name, type, characters_per_line, print_format, status) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssiss", $unique_id, $name, $type, $cpl, $format, $status);
    if ($stmt->execute()) {
        $msg = "<div class='alert alert-success'>Printer added!</div>";
    } else {
        $msg = "<div class='alert alert-danger'>Error: " . $stmt->error . "</div>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Printer - HUKO PRINT</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<nav class="navbar navbar-light bg-light mb-4">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="#">
            <img src="logo.png" alt="Logo" width="40" height="40" class="me-2">
            <span class="fs-4 fw-bold">HUKO PRINT</span>
        </a>
    </div>
</nav>
<div class="container py-4">
    <h2>Add Printer</h2>
    <form method="post">
        <input class="form-control mb-2" name="unique_id" placeholder="Unique ID" required>
        <input class="form-control mb-2" name="name" placeholder="Printer Name" required>
        <input class="form-control mb-2" name="type" placeholder="Type" required>
        <input class="form-control mb-2" name="characters_per_line" type="number" placeholder="Characters Per Line" required>
        <textarea class="form-control mb-2" name="print_format" placeholder="Print Format"></textarea>
        <select class="form-control mb-2" name="status">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
        </select>
        <button class="btn btn-primary" type="submit">Add Printer</button>
    </form>
    <?= $msg ?>
    <a href="dashboard.php">Back to Dashboard</a>
</div>
</body>
</html>
